"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, /**
 * Stopout listener for handling a stream of stopout events
 */ "default", {
    enumerable: true,
    get: function() {
        return StopoutListener;
    }
});
let StopoutListener = class StopoutListener {
    /**
   * Calls a predefined function with the packets data
   * @param {CopyFactoryStrategyStopout[]} strategyStopoutEvent strategy stopout event with an array of packets
   */ async onStopout(strategyStopoutEvent) {
        throw Error("Abstract method onStopout has no implementation");
    }
    /**
   * Calls a predefined function with the received error
   * @param {Error} error error received during retrieve attempt
   */ async onError(error) {}
};

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIjxhbm9uPiJdLCJzb3VyY2VzQ29udGVudCI6WyIndXNlIHN0cmljdCc7XG5cbi8qKlxuICogU3RvcG91dCBsaXN0ZW5lciBmb3IgaGFuZGxpbmcgYSBzdHJlYW0gb2Ygc3RvcG91dCBldmVudHNcbiAqL1xuZXhwb3J0IGRlZmF1bHQgY2xhc3MgU3RvcG91dExpc3RlbmVyIHtcblxuICAvKipcbiAgICogQ2FsbHMgYSBwcmVkZWZpbmVkIGZ1bmN0aW9uIHdpdGggdGhlIHBhY2tldHMgZGF0YVxuICAgKiBAcGFyYW0ge0NvcHlGYWN0b3J5U3RyYXRlZ3lTdG9wb3V0W119IHN0cmF0ZWd5U3RvcG91dEV2ZW50IHN0cmF0ZWd5IHN0b3BvdXQgZXZlbnQgd2l0aCBhbiBhcnJheSBvZiBwYWNrZXRzXG4gICAqL1xuICBhc3luYyBvblN0b3BvdXQoc3RyYXRlZ3lTdG9wb3V0RXZlbnQpIHtcbiAgICB0aHJvdyBFcnJvcignQWJzdHJhY3QgbWV0aG9kIG9uU3RvcG91dCBoYXMgbm8gaW1wbGVtZW50YXRpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBDYWxscyBhIHByZWRlZmluZWQgZnVuY3Rpb24gd2l0aCB0aGUgcmVjZWl2ZWQgZXJyb3JcbiAgICogQHBhcmFtIHtFcnJvcn0gZXJyb3IgZXJyb3IgcmVjZWl2ZWQgZHVyaW5nIHJldHJpZXZlIGF0dGVtcHRcbiAgICovXG4gIGFzeW5jIG9uRXJyb3IoZXJyb3IpIHt9XG5cbn0iXSwibmFtZXMiOlsiU3RvcG91dExpc3RlbmVyIiwib25TdG9wb3V0Iiwic3RyYXRlZ3lTdG9wb3V0RXZlbnQiLCJFcnJvciIsIm9uRXJyb3IiLCJlcnJvciJdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7K0JBRUE7O0NBRUMsR0FDRDs7O2VBQXFCQTs7O0FBQU4sSUFBQSxBQUFNQSxrQkFBTixNQUFNQTtJQUVuQjs7O0dBR0MsR0FDRCxNQUFNQyxVQUFVQyxvQkFBb0IsRUFBRTtRQUNwQyxNQUFNQyxNQUFNLG1EQUFtRDtJQUNqRTtJQUVBOzs7R0FHQyxHQUNELE1BQU1DLFFBQVFDLEtBQUssRUFBRSxDQUFDO0FBRXhCIn0=